import torch
import json

data_len = {'MYCaltech101': 100,
            'MYDescribableTextures': 47,
            'MYEuroSAT': 10,
            'MYFGVCAircraft': 100,
            'MYImageNet': 1000,
            'MYOxfordFlowers': 102,
            'MYOxfordPets': 37,
            'MYStanfordCars': 196,
            'MYSUN397':397,
            'MYUCF101':101,
            'MYFood101':101}

if __name__ == '__main__':
    ret = {}
    for dataname, num_class in data_len.items():
        split = torch.randperm(num_class)
        from_class = split[:int(0.5*num_class)]
        to_class = split[int(0.5*num_class):]

        ret_tmp = {}
        for order, idx in enumerate(from_class):
            ret_tmp[int(idx)] = int(to_class[order])
        for idx in to_class:
            ret_tmp[int(idx)] = int(idx)

        ret[dataname] = ret_tmp


    try:
        with open('./noise/asym_noise.json', 'w') as fp:
            json.dump(ret, fp, indent=1)
    except: 
        with open('./asym_noise.json', 'w') as fp:
            json.dump(ret, fp, indent=1)